/*
 * Decompiled with CFR 0.152.
 */
package de.caff.dxf.applet;

import de.caff.dxf.fonts.DxfFontSettings;
import de.caff.dxf.swing.DxfFrameSwing;
import de.caff.dxf.swing.optional.SVGSaveAction;
import de.caff.util.debug.Debug;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.print.PrintService;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sun.awt.AppContext;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DxfApplet
extends JApplet
implements hf,
hk,
hl {
    private static final tp a;
    public static final String VERSION = "1.40.05";
    public static final String REVISION = "$Revision: 721 $";
    public static final String FULLNAME = "DXF Viewer Applet Version 1.40.05";
    public static final String MAILTO = "dxfviewer@caff.de";
    public static final String PARAM_APPLET_INPAGE = "dxf.applet.inpage";
    public static final String PARAM_DXF_FILE = "dxf.file";
    public static final String PARAM_FRAME_WIDTH = "dxf.frame.width";
    public static final String PARAM_FRAME_HEIGHT = "dxf.frame.height";
    public static final String PARAM_GUI_DESCR = "dxf.applet.gui.descr";
    public static final String PARAM_PRINT_VIEW = "dxf.applet.print.view";
    public static final String PARAM_PRINT_FONT = "dxf.applet.print.font";
    public static final String PARAM_PRINT_TO_SCALE = "dxf.applet.print.scaled";
    public static final String PARAM_PRINT_MODE = "dxf.applet.print.mode";
    public static final String PARAM_MODEL_UNIT_LENGTH = "dxf.model.unit.length";
    public static final String PARAM_DEFAULT_CODEPAGE = "dxf.default.codepage";
    public static final String PARAM_DEFAULT_FONT = "dxf.default.font";
    public static final String PARAM_DEFAULT_BIGFONT = "dxf.default.bigfont";
    public static final String PARAM_ADDITIONAL_FONTDIR = "dxf.fontdir";
    public static final String PARAM_LOAD_BACKGROUND = "dxf.load.bg";
    public static final String DEFAULT_GUI_DESCR = "/de/caff/dxf/applet/resources/DefaultGuiDescription.xml";
    public static final double FLAT_EPSILON = 1.0E-6;
    public static final String BT_DISPLAY_FRAME = "btAppDisplayFrame";
    public static final String ERR_APP_PARSE_READ = "errAppParseRead";
    public static final String ERR_APP_CONFIG_PARSER = "errAppConfigParser";
    public static final String ERR_APP_CONFIG_IO = "errAppConfigIO";
    public static final String ERR_RESTRICT_NO_SAVE = "errRestrictNoSave";
    public static final String ERR_NO_SAVE_FORMAT = "errNoSaveFormat";
    public static final String MI_CLOSE_WINDOW = "miCloseWindow";
    private static final Pattern a;
    private static final Pattern b;
    private static final Pattern c;
    private boolean a;
    private gx a;
    private kW a;
    private Color d = a;
    private Color e = b;
    private ig a;
    private final it a;
    private im a;
    private mo a;
    private mT a;
    private mc a;
    private String a;
    private tH a;
    private JMenuBar a;
    private final Stack a;
    private File a;
    private String b;
    private vk a;
    private String c;
    private final Map a;
    private final List a;
    private y a;
    private tp b;
    private final w a;
    private final Map b = "DXF Viewer Applet %2: %0";
    private final Collection a = new w(this);
    private static final Map c;

    public DxfApplet() {
        this.b = new HashMap();
        this.a = new LinkedList();
        Debug.a("Applet constructor, this=%0", Integer.toHexString(this.hashCode()));
        try {
            sj.a(new a(this));
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Debug.c(throwable);
            return;
        }
    }

    protected URL getGuiDescriptionURL(String object) {
        Object object2 = sj.a(PARAM_GUI_DESCR, null);
        try {
            if (object2 != null) {
                return new URL(this.getDocumentBase(), (String)object2);
            }
            if (object != null) {
                object2 = object;
                return this.getClass().getResource((String)object);
            }
        }
        catch (IOException iOException) {
            object = iOException;
            Debug.c(iOException);
            this.showError(on.format(ERR_APP_CONFIG_IO, object, object2));
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized void init() {
        Debug.a("init() call starts (1)..., applet=%0, this=%1", new Object[]{DxfApplet.a(sj.a()), DxfApplet.a((Object)this)});
        if (sj.a() == this) {
            Debug.a("init() returns early");
            return;
        }
        sj.a(this);
        Debug.a(126L);
        Debug.b("Initializing dxfapplet version %0 ...", new Object[]{"1.40.05"});
        Debug.a("init() call starts (2)..., applet=%0, this=%1", new Object[]{DxfApplet.a(sj.a()), DxfApplet.a((Object)this)});
        try {
            Debug.a("AppContext: %0 (isDisposed(): %1)", new Object[]{DxfApplet.a(AppContext.getAppContext()), AppContext.getAppContext().isDisposed()});
        }
        catch (SecurityException v0) {
            var1_1 = v0;
            Debug.a(v0);
        }
        if (Debug.b()) {
            var1_1 = new StringBuilder("System Properties Info:\n");
            var2_2 = sj.a().iterator();
            while (var2_2.hasNext()) {
                var3_3 = (sa)var2_2.next();
                var1_1.append("    ").append((String)var3_3.a).append("=\"").append((String)var3_3.b).append("\"\n");
            }
            Debug.b(var1_1);
        }
        if ((var1_1 = sj.a("locale", null)) != null) {
            var2_2 = new Locale((String)var1_1);
            Debug.b("Overriding locale to %0", new Object[]{var2_2});
            this.setLocale((Locale)var2_2);
            try {
                Locale.setDefault((Locale)var2_2);
            }
            catch (SecurityException v1) {
                var3_3 = v1;
                Debug.c(v1);
            }
            on.setDefaultLocale((Locale)var2_2);
        }
        if ((var2_2 = sj.a("resourcebase", null)) != null) {
            on.addAppResourceBase((String)var2_2);
        }
        var3_3 = new i(this, "actionCopyToClipboard");
        var1_1 = new j(this, "miPrint");
        var2_2 = new k(this, "miCloseWindow");
        this.b.put("print", new Action[]{var1_1});
        this.b.put("copy", new Action[]{var3_3});
        this.b.put("close", new Action[]{var2_2});
        var1_1 = he.a(this, this.getLocale());
        this.b.put("imgsave", var1_1);
        for (String[] var5_10 : var1_1) {
            this.b.put("save" + var5_10.a().toLowerCase(), new Action[]{var5_10});
        }
        this.b.put("savepdf", new Action[]{new hi(this, this.getLocale())});
        this.b.put("saveps", new Action[]{new hj(this, this.getLocale())});
        this.b.put("savesvg", new Action[]{new SVGSaveAction(this)});
        this.a = sj.a("print.twice.workaround", true);
        sj.a("dxf.load.bg", false);
        var1_1 = sj.a("view.bgcolor", null);
        var3_5 = sj.a("dxf.file", null);
        if (sj.a("dxf.applet.inpage", true)) {
            var4_9 = this.getGuiDescriptionURL("/de/caff/dxf/applet/resources/DefaultGuiDescription.xml");
            this.a = null;
            this.a = new ig(null);
            try {
                Debug.a("Applet GUI descr: %0", new Object[]{var4_9});
                if (var4_9 != null) {
                    Debug.a("Handling Applet GUI descr %0 ...", new Object[]{var4_9});
                    this.a(var4_9.openStream(), this.getContentPane(), null);
                    Debug.a("Handled Applet GUI descr %0.", new Object[]{var4_9});
                    if (var1_1 != null) {
                        this.a.a((Color)var1_1);
                    }
                }
                if (var3_5 == null) ** GOTO lbl168
                var5_10 = DxfApplet.a.split((CharSequence)var3_5);
                var1_1 = var5_10;
                var3_6 = var5_10.length;
                for (var5_11 = 0; var5_11 < var3_6; ++var5_11) {
                    var6_19 = var1_1[var5_11];
                    Debug.a("Loading %0 ...", new Object[]{var6_19});
                    this.loadDxfFile((String)var6_19);
                    Debug.a("Loaded %0.", new Object[]{var6_19});
                }
            }
            catch (SAXException v2) {
                var5_10 = v2;
                Debug.c(v2);
                this.showError(on.format("errAppParseRead", new Object[]{var5_10, var4_9}));
            }
            catch (ParserConfigurationException v3) {
                var5_10 = v3;
                Debug.c(v3);
                this.showError(on.format("errAppConfigParser", new Object[]{var5_10, var4_9}));
            }
            catch (IOException var5_12) {
                this.showError(on.format("errAppConfigIO", new Object[]{var5_12, var4_9}));
                Debug.c(var5_12);
            }
        } else {
            var4_9 = this.getGuiDescriptionURL(null);
            if (var4_9 == null) {
                this.a = new DxfFrameSwing(null, this.getDocumentBase());
                var5_10 = this.getToolkit().getScreenSize();
                this.a.setSize(sj.a("dxf.frame.width", var5_10.width), sj.a("dxf.frame.height", var5_10.height));
                if (var1_1 != null) {
                    DxfFrameSwing.a((Color)var1_1);
                }
                this.a.setVisible(true);
                if (var3_5 != null) {
                    var3_5 = var1_1 = DxfApplet.a.split((CharSequence)var3_5);
                    var5_13 = ((String[])var1_1).length;
                    for (var6_20 = 0; var6_20 < var5_13; ++var6_20) {
                        var7_22 /* !! */  = var3_5[var6_20];
                        this.a.a((String)var7_22 /* !! */ , false);
                    }
                }
            } else {
                this.a = new ig(null);
                this.a = new l(this);
                var5_10 = this.getToolkit().getScreenSize();
                this.a.setSize(sj.a("dxf.frame.width", var5_10.width), sj.a("dxf.frame.height", var5_10.height));
                this.a.setVisible(true);
                try {
                    this.a(var4_9.openStream(), this.a.getContentPane(), this.a);
                    if (var1_1 != null) {
                        this.a.a((Color)var1_1);
                    }
                    if (var3_5 == null) ** GOTO lbl149
                    var3_5 = var1_1 = DxfApplet.a.split((CharSequence)var3_5);
                    var5_14 = ((String[])var1_1).length;
                    for (var6_20 = 0; var6_20 < var5_14; ++var6_20) {
                        var7_22 /* !! */  = var3_5[var6_20];
                        this.loadDxfFile((String)var7_22 /* !! */ );
                    }
                }
                catch (SAXException v4) {
                    var1_1 = v4;
                    Debug.c(v4);
                    this.showError(on.format("errAppParseRead", new Object[]{var1_1, var4_9}));
                }
                catch (ParserConfigurationException v5) {
                    var1_1 = v5;
                    Debug.c(v5);
                    this.showError(on.format("errAppConfigParser", new Object[]{var1_1, var4_9}));
                }
                catch (IOException v6) {
                    var1_1 = v6;
                    Debug.c(v6);
                    this.showError(on.format("errAppConfigIO", new Object[]{var1_1, var4_9}));
                }
            }
lbl149:
            // 6 sources

            var5_15 = new oB("btAppDisplayFrame");
            var1_1 = Box.createVerticalBox();
            var3_5 = Box.createHorizontalBox();
            var1_1.add(Box.createVerticalGlue());
            var1_1.add((Component)var3_5);
            var1_1.add(Box.createVerticalGlue());
            var3_5.add(Box.createHorizontalGlue());
            var3_5.add(var5_15);
            var3_5.add(Box.createHorizontalGlue());
            this.getContentPane().add((Component)var1_1);
            var5_15.addActionListener(new m(this));
            var2_2.setEnabled(this.a != null);
        }
lbl168:
        // 6 sources

        var4_9 = sj.a("i18n.dump", null);
        if (var4_9 != null) {
            var5_16 = var4_9.split("[^a-zA-Z_]+");
            var1_1 = var5_16;
            var3_7 = var5_16.length;
            block22: for (var5_17 = 0; var5_17 < var3_7; ++var5_17) {
                var6_21 = var1_1[var5_17];
                var7_22 /* !! */  = DxfApplet.c.split((CharSequence)var6_21);
                switch (var7_22 /* !! */ .length) {
                    case 1: {
                        on.dump(System.out, new Locale(var7_22 /* !! */ [0]));
                        continue block22;
                    }
                    case 2: {
                        on.dump(System.out, new Locale(var7_22 /* !! */ [0], var7_22 /* !! */ [1]));
                        continue block22;
                    }
                    case 3: {
                        on.dump(System.out, new Locale(var7_22 /* !! */ [0], var7_22 /* !! */ [1], var7_22 /* !! */ [2]));
                        continue block22;
                    }
                    default: {
                        System.out.println("Can't determine locale from: " + (String)var6_21);
                    }
                }
            }
        }
        if ((var5_18 = sj.a("dxf.applet.print.mode", null)) != null) {
            this.a = y.a(var5_18);
            if (this.a == null) {
                Debug.d("Applet uses invalid value for param %0: \"%1\"", new Object[]{"dxf.applet.print.mode", var5_18});
            }
        }
        if ((var1_1 = sj.a("dxf.applet.print.scaled", null)) != null) {
            Debug.d("Param %0 is deprecated! Use %1 instead.", new Object[]{"dxf.applet.print.scaled", "dxf.applet.print.mode"});
            if (this.a == null) {
                v7 = this.a = sj.a("dxf.applet.print.scaled", false) != false ? y.b : y.a;
            }
        }
        if (this.a == null) {
            this.a = y.a;
        }
        Debug.a("init() returns, applet=%0", new Object[]{Integer.toHexString(this.hashCode())});
    }

    private void a(InputStream inputStream, Container container, JFrame jFrame) {
        SAXParserFactory.newInstance().newSAXParser().parse(inputStream, (DefaultHandler)new q(this, container, jFrame));
    }

    public Color getProgressReadColor() {
        return this.d;
    }

    public void setProgressReadColor(Color color) {
        this.d = color;
    }

    public Color getProgressWriteColor() {
        return this.e;
    }

    public void setProgressWriteColor(Color color) {
        this.e = color;
    }

    public void loadDxfFile(String string) {
        this.loadDxfFile(string, false);
    }

    public void loadDxfFile(String string, boolean bl2) {
        SwingUtilities.invokeLater(new n(this, string, bl2));
    }

    public y getPrintMode() {
        return this.a;
    }

    public void setPrintMode(y y2) {
        if (y2 == null) {
            throw new NullPointerException("printMode may not be null!");
        }
        this.a = y2;
    }

    public tp getModelUnit() {
        return this.b;
    }

    public void setModelUnit(tp tp2) {
        if (!tp2.equals(this.b)) {
            this.b = tp2;
            for (kF kF2 : this.a) {
                kF2.a(tp2);
            }
        }
    }

    private bl a() {
        String string;
        LinkedList<String> linkedList = new LinkedList<String>(DxfFontSettings.a.a());
        Object object = this.getParameter(PARAM_ADDITIONAL_FONTDIR);
        if (object != null) {
            try {
                object = new URL(this.getDocumentBase(), (String)object);
                linkedList.add(((URL)object).toString());
            }
            catch (MalformedURLException malformedURLException) {
                object = malformedURLException;
                Debug.c(malformedURLException);
            }
        }
        if ((object = this.getParameter(PARAM_DEFAULT_FONT)) == null) {
            object = "txt.shx";
        }
        if ((string = this.getParameter(PARAM_DEFAULT_BIGFONT)) == null) {
            string = "arial.ttf";
        }
        return new bl(bl.a, G.a(this.getParameter(PARAM_DEFAULT_CODEPAGE), G.d), linkedList, DxfFontSettings.a.b(), null, (String)object, string);
    }

    public synchronized void destroy() {
        Debug.a("destroy() starts..., applet=%0, this=%1, frame=%2", DxfApplet.a(sj.a()), DxfApplet.a((Object)this), DxfApplet.a(this.a));
        if (this.a != null) {
            if (sj.a() == this) {
                sj.a(null);
            }
            this.a.setVisible(false);
            this.a.dispose();
            this.a = null;
        }
        try {
            Debug.a("AppContext: %0 (isDisposed(): %1)", DxfApplet.a(AppContext.getAppContext()), AppContext.getAppContext().isDisposed());
        }
        catch (SecurityException securityException) {
            SecurityException securityException2 = securityException;
            Debug.a(securityException);
        }
        Debug.a("destroy() ends, applet=%0", Integer.toHexString(this.hashCode()));
    }

    private static String a(Object object) {
        if (object == null) {
            return "<<null>>";
        }
        return Integer.toHexString(object.hashCode());
    }

    private static Dimension b(String string) {
        int n2;
        int n3;
        String[] stringArray = b.split(string.trim());
        if (stringArray.length != 2) {
            throw new SAXException("Not a valid size argument: " + string);
        }
        try {
            n3 = Integer.parseInt(stringArray[0]);
            n2 = Integer.parseInt(stringArray[1]);
            if (n3 < 0) {
                throw new SAXException("Negative width not allowed for size argument: " + string);
            }
            if (n2 < 0) {
                throw new SAXException("Negative height not allowed for size argument: " + string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("Not a valid size argument: " + string, numberFormatException);
        }
        return new Dimension(n3, n2);
    }

    public void showError(Throwable throwable) {
        Debug.c(throwable);
        this.repaint();
        String string = throwable instanceof op ? ((op)throwable).a(this.getLocale()) : throwable.getMessage();
        if (string == null || string.length() == 0) {
            string = throwable.toString();
        }
        this.showError(string);
    }

    public void showError(String string) {
        JOptionPane.showMessageDialog(this.a != null ? this.a : this, string, on.getString("diaError"), 0);
        this.a.b("msgError");
    }

    public void printAll(Graphics graphics) {
        this.print(graphics);
    }

    public void printComponents(Graphics graphics) {
        this.print(graphics);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void print(Graphics graphics) {
        Object object;
        if (!sj.a(PARAM_PRINT_VIEW, true)) {
            super.print(graphics);
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = this.getBounds();
            object = System.getProperty("java.vendor");
            if (object != null && ((String)object).startsWith("Netscape")) {
                Debug.c("Netscape print scaling problem workaround");
                rectangle.width = 3 * rectangle.width / 4;
                rectangle.height = 3 * rectangle.height / 4;
            }
            graphics.setClip(rectangle);
        }
        Debug.b("Print bounds: " + rectangle);
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        object = sj.a(PARAM_PRINT_FONT, "sanserif-plain-10").trim();
        if (((String)object).length() != 0) {
            object = Font.decode((String)object);
            graphics.setFont((Font)object);
            object = graphics.getFontMetrics();
            String string = this.a != null ? this.a.a() : this.c;
            String string2 = string;
            for (int i2 = 3; i2 < string.length() && ((FontMetrics)object).getStringBounds(string2, graphics).getWidth() > (double)(rectangle.width - 4); ++i2) {
                string2 = string.substring(0, string.length() / 2 - i2 / 2);
                String string3 = string.substring(string.length() / 2 + (i2 + 1) / 2);
                string2 = string2 + "..." + string3;
            }
            graphics.drawString(string2, 2, ((FontMetrics)object).getMaxAscent() + 2);
            rectangle.y = ((FontMetrics)object).getHeight() + 2;
            rectangle.height -= rectangle.y + 2;
        }
        rectangle.x += 2;
        rectangle.width -= 4;
        boolean bl2 = sj.a("print.monochrome", false);
        if (this.a != null) {
            this.a.a((Graphics2D)graphics, rectangle, bl2);
            return;
        }
        this.a((Graphics2D)graphics, rectangle, bl2);
    }

    private void a(Graphics2D object, Rectangle2D rectangle2D, boolean bl2) {
        iG iG2;
        if (this.a != null && (iG2 = this.a.a(rectangle2D, bl2)) != null) {
            float f2 = sj.a("print.strokewidth", 0.3f);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            ((Graphics)object).setClip(rectangle2D);
            ((Graphics2D)object).setStroke(new BasicStroke(f2, 0, 2));
            object = new dX((Graphics2D)object, dX.b);
            iG2.a(new dW((dZ)object, rectangle2D), null);
        }
    }

    public void printView() {
        if (this.a != null) {
            try {
                PrintService[] printServiceArray;
                boolean bl2;
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                boolean bl3 = sj.a("print.monochrome", false);
                float f2 = sj.a("print.strokewidth", 0.3f);
                Object object = this.a ? new o(this) : this.a;
                Serializable serializable = null;
                Object object2 = this;
                block3 : switch (h.a[((DxfApplet)object2).a.ordinal()]) {
                    case 1: {
                        bl2 = false;
                        break;
                    }
                    case 2: {
                        bl2 = true;
                        break;
                    }
                    case 3: {
                        for (Object object3 : ((DxfApplet)object2).a) {
                            if (!((og)object3).d()) continue;
                            bl2 = true;
                            break block3;
                        }
                    }
                    default: {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    try {
                        serializable = tp.a(sj.a(PARAM_MODEL_UNIT_LENGTH, "1mm"), Locale.US);
                    }
                    catch (tn tn2) {
                        serializable = tn2;
                        Debug.c(tn2);
                        serializable = new tp(1.0, to.b);
                    }
                }
                Debug.a("Model unit: %0", serializable);
                printerJob.setPrintable(new p(this, (tp)serializable, bl3, f2, (nR)object));
                printerJob.setJobName("DXF Viewer Applet - " + this.a);
                if (this.a != null && (printServiceArray = PrinterJob.lookupPrintServices()) != null) {
                    PrintService[] printServiceArray2 = printServiceArray;
                    int n2 = printServiceArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        object2 = printServiceArray2[i2];
                        if (!this.a.equals(object2.getName())) continue;
                        try {
                            printerJob.setPrintService((PrintService)object2);
                        }
                        catch (PrinterException printerException) {}
                        break;
                    }
                }
                if (this.a == null) {
                    this.a = new tH();
                    for (kF kF2 : this.a) {
                        kF2.a(this.a);
                    }
                    if (kF.a != null) {
                        tp tp2 = kF.a;
                        tp tp3 = kF.b;
                        object = kF.c;
                        tp tp4 = kF.d;
                        object2 = printerJob.defaultPage();
                        if (object2 != null) {
                            Object object3;
                            object3 = new tp(((PageFormat)object2).getWidth(), to.d);
                            object2 = new tp(((PageFormat)object2).getHeight(), to.d);
                            this.a.add(new MediaPrintableArea((float)tp3.a(to.b), (float)tp2.a(to.b), (float)((tp)object3).b(tp3).b(tp4).a(to.b), (float)((tp)object2).b(tp2).b((tp)object).a(to.b), 1000));
                        }
                    }
                }
                if (printerJob.printDialog(this.a)) {
                    this.a.b("msgPrinting");
                    for (kF kF3 : this.a) {
                        kF3.a();
                    }
                    this.a = printerJob.getPrintService().getName();
                    b b2 = new b(this, printerJob);
                    b2.a(new c(this));
                    Thread thread = new Thread(b2);
                    thread.setPriority(1);
                    thread.start();
                }
                return;
            }
            catch (SecurityException securityException) {
                this.showError(securityException);
                return;
            }
        }
        this.a.a();
    }

    public void copyViewToClipboard() {
        this.a.b();
    }

    public void doSave(String string, String object) {
        Object object2 = (BufferedImage)this.a.a().a(0);
        Object object3 = new File(string);
        this.a = ((File)object3).getParentFile();
        if (((File)object3).exists() && JOptionPane.showConfirmDialog(this, on.format("msgAskFileOverwrite", string), on.getString("diaOverwrite", null), 0) != 0) {
            return;
        }
        this.a.a("msgSaving", string);
        this.a.a(this.e);
        object = ImageIO.getImageWritersByFormatName((String)object);
        if (object.hasNext()) {
            object = (ImageWriter)object.next();
            object3 = new FileImageOutputStream((File)object3);
            ((ImageWriter)object).setOutput(object3);
            ((ImageWriter)object).addIIOWriteProgressListener(new d(this));
            ((ImageWriter)object).getDefaultWriteParam();
            object2 = new e(this, (ImageWriter)object, (BufferedImage)object2);
            ((sr)object2).a(new f(this, (ImageWriter)object, (FileImageOutputStream)object3, string));
            new Thread((Runnable)object2).start();
        }
    }

    public File getLastSaveDir() {
        return this.a;
    }

    public Frame getDialogParentFrame() {
        return this.a;
    }

    public iJ getTemporaryPainter() {
        return this.a.a();
    }

    public Preferences getPreferences() {
        try {
            return Preferences.userNodeForPackage(this.getClass());
        }
        catch (SecurityException securityException) {
            SecurityException securityException2 = securityException;
            Debug.b(securityException);
            return null;
        }
    }

    public double getViewAspectRatio() {
        Serializable serializable = this.a.a();
        if (serializable != null && (serializable = serializable.getSize()) != null && ((Dimension)serializable).width > 0 && ((Dimension)serializable).height > 0) {
            return (double)((Dimension)serializable).width / (double)((Dimension)serializable).height;
        }
        return 1.0;
    }

    public nR getProgressShower() {
        return this.a;
    }

    public void closeFrame() {
        if (this.a != null) {
            this.a.setVisible(false);
        }
    }

    public void showFrame() {
        if (this.a != null) {
            this.a.setVisible(true);
            this.a.toFront();
        }
    }

    public void resetView() {
        this.a.a().a(0);
    }

    public void goForward() {
        this.a.a().a();
    }

    public void goBackward() {
        this.a.a().b();
    }

    public boolean canGoForward() {
        return this.a.a().a();
    }

    public boolean canGoBackward() {
        return this.a.a().b();
    }

    public String[] getLayerNames() {
        if (this.a != null) {
            return this.a.b();
        }
        Debug.c("No access to layers when using standard DXF Viewer frame!");
        return new String[0];
    }

    public boolean isLayerVisible(String string) {
        if (this.a == null) {
            Debug.c("No access to layers when using standard DXF Viewer frame!");
            return false;
        }
        return this.a.a(string);
    }

    public void setLayerVisible(String string, boolean bl2) {
        if (this.a == null) {
            Debug.c("No access to layers when using standard DXF Viewer frame!");
            return;
        }
        this.a.a(string, bl2);
    }

    public void saveView(String string) {
        SwingUtilities.invokeLater(new g(this, string));
    }

    public int setSearchText(String string) {
        if (this.a.a() instanceof mp) {
            le le2 = ((mp)this.a.a()).a();
            if (le2 != null) {
                le2.a(string);
                return le2.b();
            }
            Debug.c("setSearchText(\"%0\") failed: search action not defined!", string);
        } else {
            Debug.c("setSearchText(\"%0\") failed: search only possible for 2D views!", string);
        }
        return -1;
    }

    public String getSearchText() {
        le le2;
        if (this.a.a() instanceof mp && (le2 = ((mp)this.a.a()).a()) != null) {
            return le2.a();
        }
        return null;
    }

    public int setSearchSettings(boolean bl2, boolean bl3, boolean bl4) {
        if (this.a.a() instanceof mp) {
            le le2 = ((mp)this.a.a()).a();
            if (le2 != null) {
                le.b(bl2);
                le.a(bl3);
                le.c(bl4);
                return le2.c();
            }
            Debug.c("setSearchSettings() failed: search action not defined!");
        } else {
            Debug.c("setSearchSettings() failed: search only possible for 2D views!");
        }
        return -1;
    }

    public int searchNext() {
        if (this.a.a() instanceof mp) {
            le le2 = ((mp)this.a.a()).a();
            if (le2 != null) {
                return le2.a() + 1;
            }
            Debug.c("setSearchSettings() failed: search action not defined!");
        } else {
            Debug.c("setSearchSettings() failed: search only possible for 2D views!");
        }
        return -1;
    }

    public int getNumberOfSearchMatches() {
        le le2;
        if (this.a.a() instanceof mp && (le2 = ((mp)this.a.a()).a()) != null) {
            return le2.c();
        }
        return -1;
    }

    public int getCurrentMatchIndex() {
        le le2;
        if (this.a.a() instanceof mp && (le2 = ((mp)this.a.a()).a()) != null) {
            return le2.d();
        }
        return -1;
    }

    public String getAppletInfo() {
        return "DXF Viewer Applet Version 1.40.05 ($Revision: 721 $) by dxfviewer@caff.de";
    }

    public String[][] getParameterInfo() {
        return new String[][]{{PARAM_DXF_FILE, "URL", "URL of DXF file to display (relative to document base)"}, {PARAM_GUI_DESCR, "URL", "URL of GUI description (relative to document base)"}, {PARAM_APPLET_INPAGE, "boolean", "Run in page (true) or in a frame (false)"}, {PARAM_FRAME_WIDTH, "int", "width of frame if not running in page"}, {PARAM_FRAME_HEIGHT, "int", "height of frame if not running in page"}, {PARAM_DEFAULT_CODEPAGE, "cp name", "name of fallback codepage if none is defined in the dxf file"}, {PARAM_ADDITIONAL_FONTDIR, "URL", "URL of directory with additional fonts (relative to docbase)"}, {PARAM_DEFAULT_FONT, "fontname", "Name of font used as a substitute for unknown fonts"}, {PARAM_DEFAULT_BIGFONT, "fontname", "Name of font used as a substitute for unknown bigfonts"}, {"locale", "ISO code", "Interface language overwrite (currently only de or en)"}, {"resourcebase", "class ref", "Additional resource (in jar)"}, {"view.bgcolor", "color", "Background colors for views"}, {"print.monochrome", "boolean", "Print all lines in black?"}, {"print.strokewidth", "float", "Stroke width for printing in points (default is 0.3)"}, {"debug.show.window", "boolean", "Show debug window?"}, {"debug.print.console", "boolean", "Print debug messages to Java console"}, {"debug.mask", "TSWEFLA", "Trace messages, Standard messages, Warnings, Errors, Fatal errors, Log messages, Assertions"}, {"print.twice.workaround", "boolean", "Assume PrinterJob is printing each page twice?"}};
    }

    public static /* synthetic */ kW a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ void a(DxfApplet dxfApplet, String object) {
        Object object2 = dxfApplet.getDocumentBase();
        object2 = new URL((URL)object2, (String)object);
        object2 = ((URL)object2).openStream();
        dxfApplet.a.a(dxfApplet.d);
        Object object3 = dxfApplet.a();
        try {
            dxfApplet.c = null;
            object3 = new ab((InputStream)object2, dxfApplet.a, (String)object, (bl)object3);
            dxfApplet.c = object;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)object2).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)object2).close();
        }
        catch (IOException iOException) {}
        object = object3;
        object2 = null;
        if (dxfApplet.a != null) {
            Object object4 = object;
            it it2 = dxfApplet.a;
            object = it2;
            object = dxfApplet.a;
            object2 = new eo((ab)object4, null, it2.c, ((it)object).d);
            dxfApplet.a.a((dI)object2);
        } else if (dxfApplet.a != null) {
            Object object5 = object;
            it it3 = dxfApplet.a;
            object = it3;
            object = dxfApplet.a;
            object2 = new gw((ab)object5, null, it3.c, ((it)object).d);
            dxfApplet.a.a((dI)object2);
        } else if (dxfApplet.a != null) {
            double d2;
            object3 = object;
            object2 = ((ab)object).a();
            nn nn2 = new nn();
            ((U)object2).a(nn2, rA.a, (ab)object3);
            object2 = nn2;
            if (object2 != null && (d2 = ((rD)(object3 = new rD((rj)(object2 = ((nn)object2).a())))).c()) != 0.0 && Math.abs(((rE)object2).e / d2) < 1.0E-6) {
                Object object6 = object;
                it it4 = dxfApplet.a;
                object = it4;
                object = dxfApplet.a;
                object2 = new eo((ab)object6, null, it4.c, ((it)object).d);
            } else {
                Object object7 = object;
                it it5 = dxfApplet.a;
                object = it5;
                object = dxfApplet.a;
                object2 = new gw((ab)object7, null, it5.c, ((it)object).d);
            }
            dxfApplet.a.a((dI)object2);
        }
        dxfApplet.a.a((dI)object2);
    }

    public static /* synthetic */ String a(DxfApplet dxfApplet) {
        return dxfApplet.b;
    }

    public static /* synthetic */ String a(String string) {
        int n2 = string.lastIndexOf(47);
        if (n2 >= 0) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    public static /* synthetic */ void a(DxfApplet dxfApplet, Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl2) {
        dxfApplet.a(graphics2D, rectangle2D, bl2);
    }

    public static /* synthetic */ gx a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ Map a() {
        return c;
    }

    public static /* synthetic */ Color a(String string) {
        if (string == null) {
            return null;
        }
        Color color = rJ.a(string);
        if (color == null) {
            throw new SAXException("Cannot decode color value: " + string);
        }
        return color;
    }

    public static /* synthetic */ Map a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ Collection a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ List a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ Map b(DxfApplet dxfApplet) {
        return dxfApplet.b;
    }

    public static /* synthetic */ Dimension a(String string) {
        return DxfApplet.b(string);
    }

    public static /* synthetic */ String a(DxfApplet dxfApplet, String string) {
        dxfApplet.b = string;
        return dxfApplet.b;
    }

    public static /* synthetic */ vk a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ vk a(DxfApplet dxfApplet, vk vk2) {
        dxfApplet.a = vk2;
        return dxfApplet.a;
    }

    public static /* synthetic */ JMenuBar a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ JMenuBar a(DxfApplet dxfApplet, JMenuBar jMenuBar) {
        dxfApplet.a = jMenuBar;
        return dxfApplet.a;
    }

    public static /* synthetic */ Stack a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ kW a(DxfApplet dxfApplet, kW kW2) {
        dxfApplet.a = kW2;
        return dxfApplet.a;
    }

    public static /* synthetic */ ig a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ it a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ im a(DxfApplet dxfApplet, im im2) {
        dxfApplet.a = im2;
        return dxfApplet.a;
    }

    public static /* synthetic */ mo a(DxfApplet dxfApplet, mo mo2) {
        dxfApplet.a = mo2;
        return dxfApplet.a;
    }

    public static /* synthetic */ mT a(DxfApplet dxfApplet, mT mT2) {
        dxfApplet.a = mT2;
        return dxfApplet.a;
    }

    public static /* synthetic */ im a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ mc a(DxfApplet dxfApplet, mc mc2) {
        dxfApplet.a = mc2;
        return dxfApplet.a;
    }

    public static /* synthetic */ String[] a(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.length();
        block5: for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case ',': {
                    if (n2 == 0) {
                        linkedList.add(stringBuilder.toString().trim());
                        stringBuilder.setLength(0);
                        continue block5;
                    }
                    stringBuilder.append(c2);
                    continue block5;
                }
                case '(': {
                    ++n2;
                    stringBuilder.append(c2);
                    continue block5;
                }
                case ')': {
                    --n2;
                    stringBuilder.append(c2);
                    continue block5;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        linkedList.add(stringBuilder.toString().trim());
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static /* synthetic */ w a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ tp a() {
        return a;
    }

    public static /* synthetic */ tH a(DxfApplet dxfApplet) {
        return dxfApplet.a;
    }

    public static /* synthetic */ void b(DxfApplet dxfApplet, String string) {
        try {
            System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            dxfApplet.showError(on.getString(ERR_RESTRICT_NO_SAVE));
            return;
        }
        String string2 = "save" + string.toLowerCase();
        Action[] actionArray = (Action[])dxfApplet.b.get(string2);
        if (actionArray != null && actionArray.length > 0) {
            if (actionArray[0].isEnabled()) {
                actionArray[0].actionPerformed(new ActionEvent(dxfApplet, 4711, "save"));
                return;
            }
            Debug.d("Action '" + string2 + "'disabled");
            return;
        }
        dxfApplet.showError(on.format(ERR_NO_SAVE_FORMAT, string.toUpperCase()));
        Debug.d("No action for saving in format '" + string + "'");
    }

    static {
        on.addAppResourceBase("de.caff.dxf.applet.DxfAppletResourceBundle");
        on.addAppResourceBase("de.caff.dxf.swing.DxfResourceBundle");
        on.addAppResourceBase("de.caff.dxf.view.swing.SwingStandardResourceBundle");
        a = new tp(0.013888888888888888, to.c);
        a = Pattern.compile("\\|");
        b = Pattern.compile("^[[:digit:]]+");
        Pattern.compile(",");
        c = Pattern.compile("_");
        c = new HashMap<String, Long>();
        c.put("all", 860921899712767L);
        c.put("zoomin", 1L);
        c.put("zoomout", 2L);
        c.put("zoom", 4L);
        c.put("zoominout", 3L);
        c.put("zoomall", 7L);
        c.put("movez", 8L);
        c.put("pan", 16L);
        c.put("rotate", 32L);
        c.put("rotate3d", 64L);
        c.put("picking", 128L);
        c.put("perspective", 65536L);
        c.put("projective", 131072L);
        c.put("orthogonal", 131072L);
        c.put("viewstates", 196608L);
        c.put("reset", 0x100000000L);
        c.put("backward", 0x10000000000L);
        c.put("forward", 0x20000000000L);
        c.put("rotateccw", 0x40000000000L);
        c.put("rotatecw", 0x80000000000L);
        c.put("fit", 0x1000000000000L);
        c.put("history", 0x30100000000L);
        c.put("rotatestep", 0xC0000000000L);
        c.put("search", 0x2000000000000L);
    }
}

